////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link RemoteAuthenticationDisplayDataCallerDelegate} object is to be informed of data approval/rejection.
 */
NS_REFINED_FOR_SWIFT
@protocol RemoteAuthenticationDisplayDataCallerDelegate <NSObject>

/**
 * Called upon data approval.
 */
- (void)onDataApproved;

/**
 * Called upon data rejection.
 */
- (void)onDataRejected;

@end

NS_ASSUME_NONNULL_END
